-- FUNCTION: public.ufd_est_prod_tbl_desc_crediario(integer, integer, integer, integer, integer, integer)

-- DROP FUNCTION public.ufd_est_prod_tbl_desc_crediario(integer, integer, integer, integer, integer, integer);

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_crediario(
	integer,
	integer,
	integer,
	integer,
	integer,
	integer,
	integer)
	
    RETURNS SETOF rs_tab_desc_prod 
    LANGUAGE 'plpgsql'

    COST 100
    VOLATILE 
    ROWS 1000
AS $BODY$

-- versã£o 23/09/2020 

 --<<inicio do corpo da funcao
-- function: select * from ufd_est_prod_tbl_desc_crediario(1, 1, 1, 1, 1)
/*  
 empresa: vetor solucoes
 funo:  ufd_est_prod_tbl_desc_crediario
 objetivo: retornar descontos do produto em tabela de desconto
 autor:  fernando junio cunha e sousa  
 criacao: 06/2012  
 coments: alterada em 12/2012 para acrescentar o controle da flag_somente_desc_contrato no cadastro convenio
			 editada por: fernando junio cunha e sousa 
 int_cd_emp          --- codigo da empresa  
 int_cd_filial       --- codigo da filial  
 int_cd_prod         --- codigo do produto  
 int_mes          --- codigo do cliente para retorno de desconto para cliente 
 int_is_receita         --- codigo do convenio ( caso seja conveniado,se nao for deve-se passar zero)  
 int_is_receita     --- indica se e venda com receita ou nãƒo
*/ 
--declara as variaveis usadas na funcao
declare
---------------------------------------------------------
----declara as variaveis que estao no cabecalho da funcao
---------------------------------------------------------
int_cd_emp              alias for $1;
int_cd_filial           alias for $2; 
int_cd_prod             alias for $3;
int_cd_mdl_vd           alias for $4;
int_is_receita          alias for $5;
int_cd_forma_pgto       alias for $6;
int_usa_desconto_propz_ident ALIAS FOR $7;
---------------------------------------------------------
---fim
---------------------------------------------------------

var_trabalhacomdescontoformadepagamento 	integer;


returnrec rs_tab_desc_prod; --recebera os dados de retorno da funcao
--declarando variavel para teste da flag 
begin --inicio dos blocos da funcao
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela temporaria de retorno
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table temp_rs_prod_tab_desc_crediario
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			flag_desc_fix 		integer,
			perc_desc			double precision,
			perc_desc_max		double precision,
			tp_nivel			integer,
			dt_ini              timestamp without time zone 
		);
		exception when others then
		truncate table temp_rs_prod_tab_desc_crediario; -- trunca a tabela se ela jã existir na corrente sessãƒo.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela que recebera as tbls vigentes
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_tab_ativa_prod_crediario
		(	
			cd_emp 		integer,    
			cd_tbl_desc integer,    
			tp_desc 	integer
		);
		exception when others then
		truncate table rs_tab_ativa_prod_crediario; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela de arvore mercadologica do produto
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_est_prod_arv_merc_crediario
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc_crediario
		exception when others then
		truncate table rs_est_prod_arv_merc_crediario; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------fim da criacao das tbls temporarias-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	--buscando arvore merc. do produto
	-------------------------------------------------------------------------------------------------------------------------------	
	insert into rs_est_prod_arv_merc_crediario		
		select 
			arv.cd_emp					,
			arv.cd_prod					,
			arv.cd_arv_merc_categ		,
			arv.cd_arv_merc_linha		,
			arv.cd_mc					,
			arv.cd_arv_merc_familia		,												
			p.cd_fabric 
		from 	est_prod_est_arv_mercadologica arv inner join est_prod p on
				arv.cd_emp		= p.cd_emp
				and arv.cd_prod = p.cd_prod
		where   	arv.cd_emp = int_cd_emp
			and 	arv.cd_prod = int_cd_prod;
			
			
	var_trabalhacomdescontoformadepagamento = coalesce((select coalesce(valor,'0')::integer from prc_filial_config where cd_chave = 'usa_desconto_pgto' and cd_filial = int_cd_filial), 0);
			
	if exists (select 1 from rs_est_prod_arv_merc_crediario) then
	
		-- todas as tabelas que nao exite receita
		insert into rs_tab_ativa_prod_crediario    
			select  a.cd_emp,    
					a.cd_tbl_desc,    
					a.cd_tp_desconto
			from est_prod_tbl_desc a inner join
                 est_prod_tbl_desc_prc_filial fil on    
					a.cd_emp = fil.cd_emp and    
					a.cd_tbl_desc = fil.cd_tbl_desc inner join    
				 est_prod_tbl_desc_crediario cred on    
					a.cd_emp =  cred.cd_emp and    
					a.cd_tbl_desc = cred.cd_tbl_desc 
			where	int_cd_emp    = a.cd_emp and        
					int_cd_filial = fil.cd_filial and
					int_cd_mdl_vd  = cred.cd_mdl_vd and
					current_date between date(a.dt_ini) and date(a.dt_fim) and
					1          = a.sts_tbl_desc and    
					19         = a.cd_tp_desconto and
					0          = a.flag_desc_receita
					AND	(
					  ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in(0,1))) OR 
					  ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz =0))
					);					
		-- inclui as tabelas que exite receita			
		if int_is_receita > 0 then		
			insert into rs_tab_ativa_prod_crediario    
				select  a.cd_emp,    
						a.cd_tbl_desc,    
						a.cd_tp_desconto
				from est_prod_tbl_desc a inner join
                 est_prod_tbl_desc_prc_filial fil on    
					a.cd_emp = fil.cd_emp and    
					a.cd_tbl_desc = fil.cd_tbl_desc inner join    
				 est_prod_tbl_desc_crediario cred on    
					a.cd_emp =  cred.cd_emp and    
					a.cd_tbl_desc = cred.cd_tbl_desc 
			where	int_cd_emp    = a.cd_emp and        
					int_cd_filial = fil.cd_filial and
					int_cd_mdl_vd  = cred.cd_mdl_vd and
					current_date between date(a.dt_ini) and date(a.dt_fim) and
					1          = a.sts_tbl_desc and    
					19         = a.cd_tp_desconto and
					1          = a.flag_desc_receita
					AND	(
					  ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in(0,1))) OR
					  ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz =0))
					);					
		end if;
		

		if var_trabalhacomdescontoformadepagamento = 1 then  
			 
	
			delete from rs_tab_ativa_prod_crediario a 
			 where not exists (select b.cd_emp
			      				 from est_prod_tbl_desc_forma_pgto b  
				    			where b.cd_emp        = a.cd_emp
				    			  and b.cd_tbl_desc   = a.cd_tbl_desc   
				    			  and b.cd_forma_pgto = int_cd_forma_pgto  
				    			    ) ;
	
		end if ; 
		
		
		if exists (select 1 from rs_tab_ativa_prod_crediario) then
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 1 - produtos    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_prod_tab_desc_crediario     
				  select    
						a.cd_tbl_desc as cd_tbl_desc,    
						a.cd_tp_desconto as tp_desc,    
						a.flag_desc_fix,    
						b.perc_desc as perc_desc,    
						b.perc_desc_max as perc_desc_max,    
						1 as tp_nivel,
						a.dt_ini    
				  from est_prod_tbl_desc a    
						inner join est_prod_tbl_desc_est_prod b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_tab_ativa_prod_crediario on    
							b.cd_emp = rs_tab_ativa_prod_crediario.cd_emp and    
							b.cd_tbl_desc = rs_tab_ativa_prod_crediario.cd_tbl_desc     
						inner join rs_est_prod_arv_merc_crediario arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_prod = arv.cd_prod           
				  where     
							int_cd_filial = fil.cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 2 - familias    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_prod_tab_desc_crediario     
				select   
						a.cd_tbl_desc as cd_tbl_desc,    
						a.cd_tp_desconto as tp_desc,    
						a.flag_desc_fix,    
						b.perc_desc as perc_desc,    
						b.perc_desc_max as perc_desc_max,   
						2 as tp_nivel,
						a.dt_ini    
				from est_prod_tbl_desc a    
						inner join est_prod_tbl_desc_est_arv_merc_familia b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_est_prod_arv_merc_crediario arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
						inner join rs_tab_ativa_prod_crediario on    
							a.cd_emp = rs_tab_ativa_prod_crediario.cd_emp and    
							b.cd_tbl_desc = rs_tab_ativa_prod_crediario.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------        
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 3 - marcas    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_prod_tab_desc_crediario     
				select
						a.cd_tbl_desc as cd_tbl_desc,    
						a.cd_tp_desconto as tp_desc,    
						a.flag_desc_fix,    
						b.perc_desc as perc_desc,    
						b.perc_desc_max as perc_desc_max,   
						3 as tp_nivel,
						a.dt_ini    
				from est_prod_tbl_desc a    
						inner join est_prod_tbl_desc_est_mc b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_est_prod_arv_merc_crediario arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_mc = arv.cd_mc    
						inner join rs_tab_ativa_prod_crediario on    
							a.cd_emp = rs_tab_ativa_prod_crediario.cd_emp and    
							b.cd_tbl_desc = rs_tab_ativa_prod_crediario.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 4 - fabricantes    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_prod_tab_desc_crediario     
				select   
						a.cd_tbl_desc as cd_tbl_desc,    
						a.cd_tp_desconto as tp_desc,    
						a.flag_desc_fix,    
						b.perc_desc as perc_desc,    
						b.perc_desc_max as perc_desc_max,   
						4 as tp_nivel,
						a.dt_ini     
				from est_prod_tbl_desc a    
						inner join est_prod_tbl_desc_est_prod_fabric b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_est_prod_arv_merc_crediario arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_fabric = arv.cd_fabric     
						inner join rs_tab_ativa_prod_crediario on    
							b.cd_emp = rs_tab_ativa_prod_crediario.cd_emp and    
							b.cd_tbl_desc = rs_tab_ativa_prod_crediario.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial;
			------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 5 - categorias        
			-------------------------------------------------------------------------------------------------------------------------------    
		    insert into temp_rs_prod_tab_desc_crediario     
				select   
						a.cd_tbl_desc as cd_tbl_desc,    
						a.cd_tp_desconto as tp_desc,    
						a.flag_desc_fix,    
						b.perc_desc as perc_desc,    
						b.perc_desc_max as perc_desc_max,   
						5 as tp_nivel,
						a.dt_ini  
				from est_prod_tbl_desc a    
						inner join est_prod_tbl_desc_est_arv_merc_categoria b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_est_prod_arv_merc_crediario arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
						inner join rs_tab_ativa_prod_crediario on    
							a.cd_emp = rs_tab_ativa_prod_crediario.cd_emp and    
							b.cd_tbl_desc = rs_tab_ativa_prod_crediario.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 6 - linhas
			-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_rs_prod_tab_desc_crediario     
				select   
						a.cd_tbl_desc as cd_tbl_desc,    
						a.cd_tp_desconto as tp_desc,    
						a.flag_desc_fix,    
						b.perc_desc as perc_desc,    
						b.perc_desc_max as perc_desc_max,   
						6 as tp_nivel,
						a.dt_ini 
				from est_prod_tbl_desc a    
						inner join est_prod_tbl_desc_est_arv_merc_linha b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_est_prod_arv_merc_crediario arv on    
							b.cd_emp = arv.cd_emp and       
							b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
						inner join rs_tab_ativa_prod_crediario on    
							a.cd_emp = rs_tab_ativa_prod_crediario.cd_emp and    
							b.cd_tbl_desc = rs_tab_ativa_prod_crediario.cd_tbl_desc        
				where     
						int_cd_filial = fil.cd_filial;
		end if;--if exists (select 1 from rs_tab_ativa_prod_crediario) then
	end if; --if exists (select 1 from rs_est_prod_arv_merc_crediario) then
	-------------------------------------------------------------------------------------------------------------------------------
	-- retornando desconto limite (resultado da funcao)
	-------------------------------------------------------------------------------------------------------------------------------
	for returnrec in 
		select cd_tbl_desc, tp_desc, flag_desc_fix, perc_desc, perc_desc_max, tp_nivel 
		  from temp_rs_prod_tab_desc_crediario 
		 --order by tp_nivel asc, perc_desc desc, dt_ini desc limit 1
		 order by tp_nivel asc, perc_desc desc, dt_ini desc  limit 1
	loop
		return next returnrec;
	end loop;				

END; --FIM DOS BLOCOS DA FUNCAO
$BODY$;

ALTER FUNCTION public.ufd_est_prod_tbl_desc_crediario(integer, integer, integer, integer, integer, integer, integer)
    OWNER TO postgres;
/*
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_crediario(integer, integer, integer, integer, integer, integer, integer)
RETURNS SETOF public.rs_tab_desc_prod AS
$body$
DECLARE RET rs_tab_desc_prod;
BEGIN
  RET = ufd_est_prod_tbl_desc_crediario($1, $2, $3, $4, $5, $6, $7);
  RETURN NEXT RET;
END
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;
*/